﻿;====================================================
; Program:          QuickUpload Alpha 2
; Author:           Lloyd Gallant (netmaestro)
; Date:             November 24, 2007
; Target Compiler:  PureBasic 4.20 and later
; Target OS:        Microsoft Windows All
; License:          Free, No restrictions on use
;====================================================

Import "kernel32.lib" 
  GetLongPathName(*shortfilename, *longfilename, buffersize) As "_GetLongPathNameW@12"
EndImport 

Declare.l Instance_Running(LockStr$)
Declare.l Callback(hwnd, msg, wparam, lparam)
Declare BatchUpLoad(void)
Declare ChangeIcon(gadget,row,column,icon)

Global totalfiles, spacing, currentheight, progress_y, currentprogress=0, uploadname$
Global tid, currentindex, soundson, currentsize
Global pendingicon, workingicon, successicon, ImgList

If InitSound() And CatchSound(0, ?transfer)
  soundson = #True
Else
  soundson = #False
EndIf

Structure fileitem
  ufile$
  itemy.l
EndStructure

Global NewList fileitems.fileitem()
Global Dim iconinfos.ICONINFO(3)
Global Dim icon(3)

#WM_NEWITEM      = #WM_APP + 1
#WM_FINISHEDITEM = #WM_APP + 2

#LVM_SETEXTENDEDLISTVIEWSTYLE = $1036 
#LVS_EX_SUBITEMIMAGES         = $2 

Enumeration 1
  #icon1
  #icon2
  #icon3
  #mask1
  #mask2
  #mask3
EndEnumeration

filename$ = (ProgramParameter())
uploadname$ = Space(260) 

GetLongPathName(@filename$, @uploadname$, 255)

If Instance_Running("quickupload")
  
  ; Send our program parameter to the main instance and end
  
  ulwindow = FindWindow_(0, "Quick Uploader")
  *pp.COPYDATASTRUCT = AllocateMemory(SizeOf(COPYDATASTRUCT))
  With *pp
    \dwData = 0
    \cbData = StringByteLength(uploadname$)+SizeOf(CHARACTER)
    \lpData = @uploadname$
  EndWith    
  SendMessage_(ulwindow, #WM_COPYDATA, #Null, *pp)
  
Else
  
  ; This is the main instance 
  ; Open the processing window and wait for the files to arrive
  
  UseJCALG1Packer()
  *unpacked = AllocateMemory(2360)
  UncompressMemory(?PicPak, ?PicPakend-?PicPak, *unpacked, 2360)
  img0 = CatchImage(#PB_Any, *unpacked, 2360)
  FreeMemory(*unpacked)
  
  GrabImage(img0, #icon1,0,0,16,16)
  GrabImage(img0, #icon2,16,0,16,16)
  GrabImage(img0, #icon3,32,0,16,16)
  FreeImage(img0)
  
  For a = #mask1 To #mask3
    CreateImage(a, 16, 16) 
    StartDrawing(ImageOutput(a)) 
      DrawImage(ImageID(a-3),0,0) 
      transcol=Point(0,0)        
      For i=0 To 15            
        For j=0 To 15 
          If Point(i,j)=transcol 
            Plot(i,j,#White) 
          Else 
            Plot(i,j,#Black) 
          EndIf 
        Next 
      Next 
    StopDrawing()   
    iconinfos(a-3)\fIcon = #True
    iconinfos(a-3)\hbmMask = ImageID(a) 
    iconinfos(a-3)\hbmColor = ImageID(a-3)
    icon(a-3) = CreateIconIndirect_(iconinfos(a-3))
  Next
  
  ImgList = ImageList_Create_(16,16,#ILC_MASK|#ILC_COLOR32,0,15)    
  pendingicon = ImageList_AddIcon_(ImgList,icon(1)) 
  workingicon = ImageList_AddIcon_(ImgList,icon(2)) 
  successicon = ImageList_AddIcon_(ImgList,icon(3))   
  
  OpenWindow(0,0,0,420,400,"Quick Uploader", $CA0001)
  ListIconGadget(0, 0,0,420,400,"File",258,#PB_ListIcon_GridLines)
  SetWindowLong_(GadgetID(0),#GWL_STYLE, GetWindowLong_(GadgetID(0),#GWL_STYLE) | #WS_CLIPCHILDREN)
  
  AddGadgetColumn(0,1,"Progress",140)
  AddGadgetItem(0, -1, uploadname$) : totalfiles + 1
  
  SendMessage_(GadgetID(0),#LVM_SETIMAGELIST,#LVSIL_SMALL,ImgList)  
  ImageList_SetBkColor_(ImgList,#CLR_NONE)  
  SendMessage_(GadgetID(0),#LVM_SETEXTENDEDLISTVIEWSTYLE,#LVS_EX_SUBITEMIMAGES,#LVS_EX_SUBITEMIMAGES) 
  ChangeIcon(0,0,0,pendingicon)
  
  spacing = SendMessage_(GadgetID(0), #LVM_GETITEMSPACING, 1, 0)
  spacing >> 16 
  item0.RECT
  item0\left = #LVIR_BOUNDS 
  SendMessage_(GadgetID(0),#LVM_GETITEMRECT,0,item0)
  currentheight = item0\top + 3
  
  AddElement(fileitems())
  fileitems()\ufile$ = uploadname$ 
  fileitems()\itemy = currentheight 
  currentheight + spacing
  SetWindowCallback(@Callback(),0)
  
  s = ElapsedMilliseconds()
  While (ElapsedMilliseconds()-s < 500)
    WindowEvent()
    Delay(1)
  Wend
    
  ResetList(fileitems())
  tid = CreateThread(@BatchUpload(),0)
    
  Repeat
    ev = WaitWindowEvent(10)
      Select ev
      Case #WM_NEWITEM
        currentindex + 1
        ChangeIcon(0,currentindex,0,workingicon)
        ProgressBarGadget(1, 262, progress_y,134,12,0,currentsize)
        SetGadgetColor(1, #PB_Gadget_BackColor, #White)
        SetGadgetColor(1, #PB_Gadget_FrontColor, RGB(160,160,255))
        SetParent_(GadgetID(1),GadgetID(0))
      Case #WM_FINISHEDITEM
        ChangeIcon(0,currentindex,0,successicon)
        If IsGadget(1)
          SetGadgetState(1, currentsize)
          Delay(500)
          FreeGadget(1)
        EndIf
    EndSelect
    If IsGadget(1)
      SetGadgetState(1, currentprogress)
    EndIf
  Until ev = #PB_Event_CloseWindow
EndIf

Procedure.l Callback(hwnd, msg, wparam, lparam)
  result = #PB_ProcessPureBasicEvents
  Select msg
    Case #WM_COPYDATA
      *pp.COPYDATASTRUCT = lparam
      string$ = PeekS(*pp\lpData, #PB_Ascii)
      AddGadgetItem(0, -1, string$)
      totalfiles + 1
      ChangeIcon(0,currentindex,0,pendingicon)
      currentindex + 1
      AddElement(fileitems())
      fileitems()\ufile$ = string$ 
      fileitems()\itemy = currentheight 
      currentheight + spacing
      result = 1
  EndSelect
  ProcedureReturn result
EndProcedure

Procedure BatchUpLoad(void)
  ; Upload to FTP server
  
  gotprefs = #False
  tries = 0 : maxtries = 1
  Repeat
    If OpenPreferences(GetHomeDirectory()+"quickupload.ini")
      server$   = ReadPreferenceString("server","")
      user$     = ReadPreferenceString("user","")
      password$ = ReadPreferenceString("password","")
      folder$   = ReadPreferenceString("folder","")
      port      = Val(ReadPreferenceString("port",""))
      passive   = ReadPreferenceLong("passive", 1)
      ClosePreferences()
      gotprefs = #True
    Else
      tries+1
      If tries <= maxtries
        RunProgram("quconfig.exe","",GetHomeDirectory(),#PB_Program_Wait)
      EndIf
    EndIf
  Until tries > maxtries Or gotprefs = #True
  
  
  If OpenFTP(0, server$, user$, password$, passive, port)
    
    currentindex = -1
    ForEach fileitems()
      currentfile$ = fileitems()\ufile$
      currentsize = FileSize(currentfile$)
      progress_y = fileitems()\itemy
      uploadedname$ = folder$+"/"+GetFilePart(currentfile$)
      Result = SendFTPFile(0, currentfile$, uploadedname$, 1)
      If result
        PostMessage_(WindowID(0), #WM_NEWITEM, progress_y, currentsize)
        Repeat
          Delay(300)
          currentprogress = FTPProgress(0)
        Until FTPProgress(0) = -3 Or FTPProgress(0) = -2
        If FTPProgress(0) = -3
          PostMessage_(WindowID(0), #WM_FINISHEDITEM, 0, 0)
          If soundson
            PlaySound(0)
            Delay(1000)
          EndIf
        EndIf
      EndIf    
      CloseFTP(0)
      OpenFTP(0, server$, user$, password$, passive, port)
    Next
  Else
    MessageRequester("Error", "Connection Failed", #MB_ICONERROR)
  EndIf
  
EndProcedure

Procedure.l Instance_Running(LockStr$)
  *MyMutex = CreateMutex_(#Null, 1, LockStr$)
  If *MyMutex <> 0 And GetLastError_() = #ERROR_ALREADY_EXISTS
    CloseHandle_(*MyMutex)
    ProcedureReturn #True
  Else
    ProcedureReturn #False
  EndIf
EndProcedure

Procedure ChangeIcon(gadget,row,column,icon) ; by paul
  LVG.lv_item      
  LVG\mask=#LVIF_IMAGE|#LVIF_TEXT 
  LVG\iItem=row 
  LVG\iSubItem=column
  txt$=GetGadgetItemText(gadget,row,column)
  LVG\pszText=@txt$ 
  LVG\iImage=icon  
  SendMessage_(GadgetID(gadget),#LVM_SETITEM,0,@LVG) 
EndProcedure

DataSection
  PicPak:
  Data.b $4A,$43,$38,$09,$00,$00,$83,$BA,$3F,$4D,$B3,$A9,$D0,$20,$69,$14,$49,$88,$12,$CA
  Data.b $08,$B0,$4A,$10,$25,$98,$0C,$30,$46,$02,$89,$81,$20,$70,$60,$10,$D8,$42,$DF,$A3
  Data.b $FF,$14,$8D,$2F,$C1,$BE,$96,$B6,$97,$C8,$24,$33,$D7,$4B,$71,$EA,$BE,$01,$5F,$05
  Data.b $3D,$20,$31,$AF,$00,$FB,$98,$24,$48,$85,$B8,$61,$AC,$04,$AE,$E3,$25,$C0,$26,$ED
  Data.b $87,$4F,$A6,$4F,$15,$61,$C0,$BE,$97,$34,$24,$CC,$F5,$4B,$D0,$03,$1E,$6D,$30,$D6
  Data.b $06,$55,$F3,$1B,$68,$56,$AA,$C2,$24,$C6,$B1,$2A,$E8,$01,$99,$00,$B3,$82,$3B,$32
  Data.b $01,$6F,$F9,$7D,$32,$42,$99,$F4,$CF,$3F,$7E,$FF,$7E,$E4,$24,$AA,$7B,$49,$46,$B2
  Data.b $FA,$BE,$23,$8F,$C4,$BE,$28,$84,$36,$A0,$8C,$82,$B1,$4E,$AC,$0D,$FC,$EA,$B6,$00
  Data.b $A3,$60,$07,$4E,$C8,$8B,$10,$D2,$26,$B5,$24,$BB,$DF,$06,$E3,$D3,$FD,$D8,$D4,$F6
  Data.b $25,$6C,$E1,$AF,$02,$12,$CF,$AF,$03,$25,$04,$2E,$92,$00,$49,$DE,$C6,$2F,$17,$60
  Data.b $34,$8C,$80,$51,$30,$C6,$9B,$7C,$9F,$4C,$8D,$01,$63,$45,$64,$BD,$6E,$33,$E9,$5E
  Data.b $04,$D6,$09,$55,$F7,$12,$3C,$E7,$42,$29,$49,$06,$9A,$97,$84,$E7,$AF,$B7,$A1,$13
  Data.b $7C,$92,$FA,$BE,$01,$6A,$46,$FC,$26,$D1,$58,$3B,$1A,$BD,$27,$14,$02,$1B,$7E,$0E
  Data.b $D4,$42,$E7,$9B,$09,$66,$A7,$A5,$68,$13,$12,$6C,$62,$9C,$FB,$24,$B7,$44,$0E,$6A
  Data.b $52,$DF,$6B,$78,$7E,$AE,$B4,$F0,$6D,$2F,$E7,$05,$F3,$92,$E5,$4B,$12,$9E,$F9,$FE
  Data.b $25,$7B,$75,$82,$45,$92,$6B,$C1,$E0,$BC,$5C,$C3,$89,$49,$B8,$18,$4D,$92,$B3,$F0
  Data.b $FD,$A2,$0C,$BC,$6D,$12,$9C,$88,$E7,$1C,$A3,$4D,$78,$6F,$09,$6E,$86,$56,$E6,$04
  Data.b $FF,$F9,$1E,$6C,$22,$1C,$FE,$24,$78,$4B,$76,$89,$C5,$DF,$37,$49,$4E,$F6,$69,$DF
  Data.b $DF,$57,$93,$48,$44,$2F,$6A,$1A,$C0,$49,$A2,$ED,$4B,$30,$7B,$CB,$DE,$24,$35,$80
  Data.b $E4,$27,$7E,$1A,$AD,$44,$31,$09,$7C,$FF,$A0,$24,$E7,$CD,$63,$AD,$0A,$A4,$A2,$ED
  Data.b $0B,$80,$89,$7C,$E9,$92,$DA,$A4,$78,$CE,$58,$AF,$6B,$41,$F4,$99,$30,$98,$A5,$26
  Data.b $61,$93,$B8,$AD,$89,$F2,$00,$23,$48,$F3,$12,$CB,$F5,$ED,$33,$60,$0C,$69,$A0,$24
  Data.b $36,$D7,$50,$82,$34,$5E,$F3,$95,$28,$89,$92,$94,$26,$5A,$18,$9E,$87,$D8,$55,$41
  Data.b $0F,$48,$C1,$C6,$59,$88,$84,$CF,$4C,$82,$4D,$70,$3F,$9C,$F9,$D5,$DB,$41,$FF,$44
  Data.b $C2,$26,$D6,$A4,$4D,$8E,$A2,$49,$73,$AA,$9C,$F9,$20,$CD,$B4,$37,$9A,$24,$6C,$34
  Data.b $7E,$B2,$95,$28,$1A,$D2,$07,$1C,$8A,$A2,$0E,$D2,$AA,$80,$63,$30,$C9,$52,$F3,$AE
  Data.b $55,$34,$E4,$F6,$60,$93,$BE,$AD,$C9,$FB,$4F,$90,$17,$F5,$A5,$26,$FB,$E1,$98,$EB
  Data.b $AD,$82,$65,$89,$79,$12,$24,$E1,$29,$2C,$C5,$BC,$CD,$59,$3E,$0D,$69,$12,$3C,$4C
  Data.b $72,$78,$90,$13,$96,$A2,$89,$3E,$96,$9B,$3D,$D2,$93,$36,$88,$F0,$26,$BD,$87,$B6
  Data.b $9C,$B3,$25,$E9,$FA,$9E,$69,$42,$B1,$21,$D0,$16,$9D,$6A,$05,$83,$44,$2E,$8C,$9E
  Data.b $F5,$61,$93,$90,$54,$6F,$BC,$12,$E0,$46,$10,$DA,$F2,$E8,$F2,$86,$34,$60,$4D,$42
  Data.b $33,$82,$53,$CD,$A2,$27,$93,$44,$15,$9E,$83,$E7,$A9,$3A,$49,$DD,$F8,$12,$9E,$F3
  Data.b $B4,$38,$BE,$9F,$13,$18,$2A,$3C,$27,$A9,$53,$18,$26,$B9,$D2,$24,$B4,$F1,$B1,$AD
  Data.b $04,$18,$60,$00,$9E,$B3,$C6,$ED,$4F,$3D,$6D,$83,$13,$F7,$D7,$82,$B4,$89,$23,$60
  Data.b $B3,$2E,$8D,$48,$CB,$79,$7E,$15,$8D,$DB,$E0,$9E,$64,$FB,$ED,$46,$08,$5C,$62,$19
  Data.b $8C,$59,$D1,$2B,$16,$8D,$1D,$60,$1E,$8C,$90,$C6,$BA,$C5,$26,$DB,$09,$5B,$31,$AE
  Data.b $01,$AC,$36,$87,$8D,$87,$0F,$C6,$8A,$36,$8A,$E9,$02,$CC,$45,$56,$93,$EE,$65,$20
  Data.b $5C,$56,$C2,$65,$05,$C5,$0D,$C5,$E5,$07,$15,$5D,$80,$D9,$22,$64,$85,$93,$BC,$26
  Data.b $D4,$D9,$CE,$BC,$AC,$80,$6B,$00,$E2,$3C,$0B,$CE,$4B,$72,$38,$AF,$61,$F0,$E8,$02
  Data.b $8C,$2F,$40,$28,$0A,$BD,$00,$44,$22,$13,$00,$00,$00,$00
  PicPakend:
  transfer:
  IncludeBinary "success.wav"
  transferend:
EndDataSection


; IDE Options = PureBasic 6.10 beta 6 (Windows - x86)
; CursorPosition = 212
; FirstLine = 208
; Folding = -
; EnableXP
; Executable = quickupload.exe
; SubSystem = DirectX9